({
    
    //This function will return an array of predicted addresses based on the user input
	getAddressSuggestions : function(component, event, helper){	
	 
        var input = component.get('v.address1');
        
        //Only search for predictions if the input isn't null or empty
        if(Boolean(input)){           
        
        var params = {
          "input" : input	
        } 
		
        //Call the getSuggestions function in the GAC controller. If there are predictions, we'll set the array of addresses returned to the v.predictions list in the component
        helper.callServer(component,"c.getSuggestions",function(response){
            var resp = JSON.parse(response);
            component.set('v.predictions',resp.Addresses);	
        },params);	
        }
        //If no predictions are returned, v.predictions will be set to an empty list
        else{
            component.set('v.predictions', []);
        }
     
    },
    
    //This function will get additional details about an address that a user clicks.
	getSelectedDetails : function(component, event, helper){		 
 
        var selectedItem = event.currentTarget;
        
        //Get the Index of the selected address so we know which one the user pixed.
        var index = selectedItem.getAttribute("data-row-index");
        
        //Pull back the user's selected address
        var selection = component.get('v.predictions')[index];
        
        
        var addressType = selection.AddressType;
        var placeid = selection.Id;
  
        var params = {
               "placeId" : placeid  	
            } 
        
        //If the address type is BuildingNumber, then we'll call the getUnits method to return all the available units for an address
        if(addressType == "BuildingNumber"){
            
            helper.callServer(component,"c.getUnits",function(response){
            var buildingDetails = JSON.parse(response);            
            component.set('v.predictions', buildingDetails.Addresses);         
        }, params);
        }
     	else
        {
            //If the user selected a regular address, then we'll call the getDetails function of the GAC controller which will get additional details about the users selected address
            helper.callServer(component,"c.getDetails",function(response){
                var placeDetails = JSON.parse(response);
                
                //This where we do the "autofill" and set the input form values to the values the service found on the use selected address
                component.set('v.address1',placeDetails.AddressInfos[0].Address1);
                component.set('v.city',placeDetails.AddressInfos[0].Locality);
                component.set('v.state',placeDetails.AddressInfos[0].AdminArea);
                component.set('v.zip',placeDetails.AddressInfos[0].PostalCode);
                component.set('v.country',placeDetails.AddressInfos[0].Country);
                
                //Set the predictions List to an Empty Array
                component.set('v.predictions',[]); 
            },params);	
        }
    }
})